unit ucOrderDetails;

interface

uses SysUtils, System.Data, System.Drawing, System.Web, System.Web.UI, System.Collections,
     System.Web.UI.WebControls, System.Web.UI.HtmlControls, Borland.Data.Provider, Borland.Data.Common;
     
type
    /// <summary>
    /// Summary description for WebUserControl1.
    /// </summary>
  TucOrderDetails = class(System.Web.UI.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    lblCustomerID: System.Web.UI.WebControls.Label;
    lblCustomerName: System.Web.UI.WebControls.Label;
    lblCustomerEmail: System.Web.UI.WebControls.Label;
    lblOrderNumber: System.Web.UI.WebControls.Label;
    lblOrderDate: System.Web.UI.WebControls.Label;
    lblShipDate: System.Web.UI.WebControls.Label;
    lblTotal: System.Web.UI.WebControls.Label;
    ErrorMessage: System.Web.UI.WebControls.Label;
    dgOrderDetails: System.Web.UI.WebControls.DataGrid;
    dlSubMenu: System.Web.UI.WebControls.DataList;
    procedure OnInit(e: System.EventArgs); override;
  private
    procedure GetCustomer(const cid :  string);
    procedure BindSubMenu;
  public
    { Public Declarations }
  end;

implementation

uses Helper, HelperDB, ordersDB;

procedure TucOrderDetails.Page_Load(sender: System.Object; e: System.EventArgs);
var
  orderID : integer;
  CustomerID : string;
  orderHistory : TOrdersDB;
	myOrderDetails : TOrderDetailsDB;
begin
    // Obtain from QueryString
  if (Assigned(Request.Params['orderid'])) AND
    (Request.Params['orderid'] <> EmptyStr) AND
    (Assigned(Request.Params['custid'])) AND
    (Request.Params['custid'] <> EmptyStr) then
  begin
    OrderID := Int32.Parse(Request.Params['orderid']);
    CustomerID := Request.Params['custid'].ToString;

    GetCustomer(CustomerID);


    BindSubMenu;

    // Obtain Order Details from Database
    orderHistory := TOrdersDB.Create;
    myOrderDetails := TOrderDetailsDB.Create;
    myOrderDetails := orderHistory.GetOrderDetails(OrderID, CustomerId);

    // if order was found, display it
    If Assigned(myOrderDetails) Then
    begin
      // Bind Items to GridControl
      dgOrderDetails.DataSource := myOrderDetails.OrderItems;
      dgOrderDetails.DataBind;

      // Update labels with summary details
      lblTotal.Text := System.String.Format('{0:c}', myOrderDetails.OrderTotal);
      lblOrderNumber.Text := Convert.ToInt32(OrderID).ToString;
      lblOrderDate.Text := DateToStr(myOrderDetails.OrderDate);
      lblShipDate.Text := DateToStr(myOrderDetails.ShipDate);
    end
    else
    begin
      //otherwise display an error message
      ErrorMessage.Text := 'Order not found!';
    end;
  end;
end;

procedure TucOrderDetails.OnInit(e: System.EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TucOrderDetails.InitializeComponent;
begin
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


procedure TucOrderDetails.GetCustomer(const cid: string);
var
  selSQL : string;
  dr : BDPDataReader;
begin
  selSQL := 'SELECT * FROM Customers WHERE CustomerID = ' + cid + ' And (IsAdmin <> 1 OR IsAdmin is null)';
  try
    dr := THelperDB.FillReader(selSQL);
    while dr.Read do
    begin
      lblCustomerID.Text := dr['CustomerID'].ToString();
      lblCustomerName.Text := dr['FullName'].ToString();
      lblCustomerEmail.Text := dr['EmailAddress'].ToString();
    end;
  except on E:Exception do
    ErrorMessage.Text := 'Could not locate customer. Error: '  + e.ToString();
  end;

end; (*GetCustomer*)

procedure TucOrderDetails.BindSubMenu;
var
  al : ArrayList;
begin
  al := ArrayList.Create;

  al.Add(TLinkList.Create('Customers', 'default.aspx?action=customers'));
  al.Add(TLinkList.Create('Orders', 'default.aspx?action=orders&custid=' + Request.Params['custid'].ToString));

  dlSubMenu.DataSource := al;
  dlSubMenu.DataBind();
end; (*BindSubMenu*)

end.
